import { StyleSheet } from "react-native";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";
import { I18nManager } from "react-native";

export const orderSummaryStyle = StyleSheet.create({
    cont: {
        flex: 1,
        backgroundColor: "#FFF",
    },
    container: {
        backgroundColor: "#fff",
        paddingHorizontal: dpr(20),
        paddingBottom: dpr(20),
    },
    accordionContainer:{
        marginTop: dpr(25),
        backgroundColor: "#fff",
        borderColor: "#DFDFDF",
        borderWidth: 1,
        borderRadius: dpr(8),
    },
    accordion:{
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "space-between",
        padding: dpr(12),
    },
    accordionTitle:{
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(16),
        color: "#2C2C2C",
        lineHeight: dpr(21),
    },
    accordionDetails: {
        maxHeight: dpr(190),
    },
    productVariation: {
        fontFamily: "Roboto_500Medium",
        alignItems: "flex-start",
        fontSize: dpr(10),
        color: "#898989",
        marginTop: dpr(4),
    },
    shippingTitle: {
        textAlign: "left",
    },
    productTitle: {
        flexDirection: "row",
        justifyContent: "space-between",
        alignItems: "center",
    },
    indicatorCont: {
        flexDirection: "row",
        justifyContent: "center",
        paddingBottom: dpr(5),
        backgroundColor: "#fff",
        paddingHorizontal: dpr(20),
    },
    orderIndicator: {
        width: dpr(50),
        borderBottomWidth: dpr(4),
        borderRadius: dpr(26),
        marginHorizontal: 2,
    },
    allProducts: {
        marginTop: dpr(25),
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(16),
        color: "#2C2C2C",
        marginBottom: dpr(15),
    },
    mh150: {
        maxHeight: dpr(150)
    },
    productsContainer: {
        borderBottomWidth: 1,
        borderColor: "#DFDFDF",
        paddingBottom: dpr(20),
    },
    productCont: {
        paddingHorizontal: dpr(12),
        paddingBottom: dpr(12),
    },
    productName: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(14),
        color: "#2C2C2C",
    },
    productNameWidth: {
        width: '75%'
    },
    priceingCont: {
        flexDirection: "row",
        justifyContent: "space-between",
        marginBottom: dpr(18),
    },
    grandTotal: {
        backgroundColor: "#F3F3F3",
        padding: dpr(11),
        borderRadius: 6,
    },
    price: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(16),
        color: "#2C2C2C",
        lineHeight: dpr(21),
    },
    cuponText: {
        marginTop: dpr(25),
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(14),
        color: "#2C2C2C",
    },
    cuponInput: {
        flexDirection: "row",
        marginTop: dpr(15),
    },
    input: {
        width: (dpr("wf") - dpr(20) * 2) * 0.75,
        height: dpr(50),
        padding: dpr(10),
        fontSize: dpr(14),
        lineHeight: dpr(16),
        fontFamily: "Roboto_400Regular",
        color: "#898989",
        borderColor: "#DFDFDF",
        borderTopWidth: 1,
        borderBottomWidth: 1,
        borderTopLeftRadius:I18nManager.isRTL ? 0 : 6,
        borderBottomLeftRadius: I18nManager.isRTL ? 0 : 6,
        borderTopRightRadius:I18nManager.isRTL ? 6 : 0,
        borderBottomRightRadius: I18nManager.isRTL ? 6 : 0,
        borderLeftWidth: I18nManager.isRTL ? 0 : 1,
        borderRightWidth: I18nManager.isRTL ? 1 : 0,
        textAlign: I18nManager.isRTL ? "right" : "left",
    },
    couponApplyBtn: {
        backgroundColor: "#2C2C2C",
        width: (dpr("wf") - dpr(20) * 2) * 0.25,
        borderTopRightRadius: 6,
        borderBottomRightRadius: 6,
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "center",
    },
    inputText: {
        color: "#fff",
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(16),
    },
    couponInfoText: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(13),
        lineHeight: dpr(15),
        marginTop: dpr(10),
        marginBottom: dpr(6),
    },
    couponErrorText: {
        color: "#E43147",
        lineHeight: dpr(18),
    },
    couponSuccessText: {
        color: "#328544",
    },
    checkoutBtnCont: {
        backgroundColor: "#FFFFFF",
        flexDirection: "row",
        justifyContent: "center",
        paddingVertical: dpr(10),

        shadowColor: "#000",
        shadowOffset: {
            width: 0,
            height: 12,
        },
        shadowOpacity: 0.6,
        elevation: 24,
    },
    radioBtn: {
        flexDirection: "row",
        justifyContent: "space-between",
        alignItems: "center",
        marginBottom: dpr(22),
    },
    shippingInfo: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(14),
        color: "#2C2C2C",
        lineHeight: dpr(18),
    },
    selectShippingBg: (selectedItem) => ({
        color: selectedItem ? '#2C2C2C' : '#898989',
    }),
    shippingBorderColor: (selectedItem) => {
        return selectedItem ? "#2C2C2C" : "#DFDFDF"
    },
    deleteCouponCont: {
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "space-between",
        marginTop: dpr(16),
    },
    deleteCouponSubCont: {
        flexDirection: "row",
        alignItems: "center",
    },
    couponCode: {
        marginLeft: dpr(10),
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(14),
        lineHeight: dpr(18),
        color: "#2C2C2C",
    },
});
